#!/bin/bash
###############################################
# Name: installCS2User.sh
# Date: 20181115
# Author: MLA
###############################################
#Changes:
#20141016 - KAK instalation changes 
#         - new KAK files
#         - new check functions
#20181115 - added support for Linux Mint 
#         - KAK instalation procedures changes
#20200904 - Linux Mint name has changed - patch
###############################################
# Settings
###############################################
if [ -f /bin/uname ] && [ -f /usr/bin/lsb_release ] ; then
    ARCH=$(/bin/uname -i)
    DISTRONAME=$(/usr/bin/lsb_release -is)
else
    echo "File /bin/uname or /usr/bin/lsb_release does not exists"
    exit 15
fi



if [ "${DISTRONAME,,}" = "ubuntu" ] || [ "${DISTRONAME,,}" = "linuxmint" ] ; then
    
    if [ "$ARCH" = "i386" ] || [ "$ARCH" = "i686" ] ; then
	LIBPREFIX=/usr/lib/i386-linux-gnu
    elif [ "$ARCH" = "x86_64" ] ; then
	LIBPREFIX=/usr/lib/x86_64-linux-gnu
    else
	echo "Unknown architecture!!!"
	exit 12
    fi
elif [ "$DISTRONAME" = "CentOS" ] || [ "$DISTRONAME" = "RedHatEnterpriseServer" ] ; then
    if [ "$ARCH" = "i386" ] || [ "$ARCH" = "i686" ] ; then
	LIBPREFIX=/usr/lib
    elif [ "$ARCH" = "x86_64" ] ; then
	LIBPREFIX=/usr/lib64
    else
	echo "Unknown architecture!!!"
	exit 12
    fi
else
    echo "This distribution is not supported!!!"
    exit 11
fi

MOZ_PLUGINS=~/.mozilla/plugins

if [ "$ARCH" = "i386" ] || [ "$ARCH" = "i686" ] ; then
	CSASHOME=$HOME/csas/lib/x86
	LIBNPCOMP=$MOZ_PLUGINS/libnpPKIComponentNPAPI.so
elif [ "$ARCH" = "x86_64" ] ; then
	CSASHOME=$HOME/csas/lib/x64
	LIBNPCOMP=$MOZ_PLUGINS/libnpPKIComponentNPAPI-64.so
else
	echo "Unknown architecture"
	exit 1
fi

KAKLIBPREFIX=$LIBPREFIX/kak
COMPONENT_DIR=$CSASHOME

CSEFILES[1]=libcsep11.so
CSEFILES[2]=libcsep11p.so
CSEFILES[3]=libcsep11p.sig

KAKFILES[1]=libnpPKIComponentNPAPI.so
KAKFILES[2]=libnpPKIComponentNPAPI.so.sig
KAKFILES[3]=libcsep11.so.sig
KAKFILES[4]=libcsep11p.so.sig
KAKFILES[5]=libcsep11p.sig.sig
KAKFILES[6]=extensionSettings.xml
KAKFILES[7]=extensionSettings.xml.sig
KAKFILES[8]=mci-proxy-host
KAKFILES[9]=mci-proxy-host.sig


OPERA_SETTINGS_DIR=~/.opera
OPERA_PLUGINPATH=$OPERA_SETTINGS_DIR/pluginpath.ini
OPERA_PLUGINS_KEY=.mozilla/plugins

###############################################
#Functions
###############################################
function copy2CSAS () {
local FILE=$1
if [ -f $FILE ] && [ -d $CSASHOME ] ; then
    /bin/cp -Lf $FILE $CSASHOME/
else 
    echo "File $FILE or directory $CSASHOME does not exist"
    exit 15
fi
}

function setPerm () {
local FILE=$1
if [ -f $FILE ]; then
    /bin/chown $USER $FILE
    /bin/chmod 644 $FILE
else
    echo "File $FILE does not exist"
    exit 15
fi
}

function checkFile () {
local FILE=$1
if [ ! -f $FILE ] ; then
	echo "File $FILE does not exists"
	exit 15
fi
}

function checkCSASHOME () {
if [ ! -d $CSASHOME ] ; then
	/bin/mkdir -p $CSASHOME
fi
}

function installFiles () {
for f in ${CSEFILES[*]} ; do
	checkFile $LIBPREFIX/$f && \
	copy2CSAS $LIBPREFIX/$f && \
	setPerm $CSASHOME/$f
done 

for f in ${KAKFILES[*]} ; do
	checkFile $KAKLIBPREFIX/$f && \
	copy2CSAS $KAKLIBPREFIX/$f && \
	setPerm $CSASHOME/$f
done 

}

function checkOperaRunning {
#MBE
if ps -e | grep opera
then 
	echo "Opera is running - cannot proceed!! Please switch off Opera and press Enter."
	read Input
	echo "Pressed $NAME!"
	
	# try again
	if ps -e | grep opera
	then
		echo "Opera still running - ask again."
		bContinue=true
	else
		echo "Opera no more running - OK."
		bContinue=false
	fi
else
	echo "Opera not running - OK"
	bContinue=false
fi
}

function checkChromeRunning {
	if ps -e | grep chrome
	then 
		echo "Chrome is running - cannot proceed!! Please switch off Chrome and press Enter."
		read Input
		echo "Pressed $NAME!"
		
		bContinue=true
	else
		echo "Chrome not running - OK"
		bContinue=false
	fi
}

function checkMozillaPluginDir {
#check if exists mozilla plugins directory
if [ ! -d $MOZ_PLUGINS ] ; then
	mkdir -p  $MOZ_PLUGINS
fi
}

function createKAKSymlink {
#MBE
# create symlink for Firefox and Chrome
if [ -f $CSASHOME/${KAKFILES[1]} ] ; then
    ln -sf $CSASHOME/${KAKFILES[1]} $LIBNPCOMP
elif [ ! -f $CSASHOME/${KAKFILES[1]} ] ; then
    echo "File $CSASHOME/${KAKFILES[1]} does not exists !!!"
    exit 15
fi
}

function registerKAK2Opera {
#MBE
# extra registration for Opera
#checking if the $OPERA_PLUGINPATH directory exists..
echo "checking if the $OPERA_PLUGINPATH directory exists.."
if [ ! -f $OPERA_PLUGINPATH ]
then
	echo "$OPERA_PLUGINPATH does not exist"
	if [ ! -d $OPERA_SETTINGS_DIR ]
	then
		echo "creating $OPERA_SETTINGS_DIR"
		mkdir $OPERA_SETTINGS_DIR

		rc=$?
		if [[ $rc != 0 ]] ; then
			echo "ERROR mkdir $OPERA_SETTINGS_DIR - code: $rc"
			exit $rc
		fi
	else
		echo "$OPERA_SETTINGS_DIR already exists - OK"
	fi

	echo "creating file $OPERA_PLUGINPATH"
	echo "[Paths]" > $OPERA_PLUGINPATH

	rc=$?
	if [[ $rc != 0 ]] ; then
		echo "ERROR writing to $OPERA_PLUGINPATH- code: $rc"
		exit $rc
	fi

	echo "$MOZ_PLUGINS=1" >> $OPERA_PLUGINPATH
else
	echo "$OPERA_PLUGINPATH already exists, checking its contents.."
	OPERA_KEY_Q=`grep -F "$OPERA_PLUGINS_KEY" $OPERA_PLUGINPATH`
	#echo "result: $OPERA_KEY_Q"
	if [[ $(grep -F "$OPERA_PLUGINS_KEY" $OPERA_PLUGINPATH 2> /dev/null) ]]
	then 
		echo "$OPERA_PLUGINPATH already contains the $OPERA_PLUGINS_KEY string - OK"
	else
		echo "$MOZ_PLUGINS string needs to be created"
		echo "Checking if Opera is running.."
		bContinue=true
		while $bContinue ; do
			checkOperaRunning
		done

		echo "Appending mozilla plugin registration"
		#echo "" >> $OPERA_PLUGINPATH
		echo "$MOZ_PLUGINS=1" >> $OPERA_PLUGINPATH

		rc=$?
		if [[ $rc != 0 ]] ; then
			echo "ERROR mkdir $OPERA_SETTINGS_DIR - code: $rc"
			exit $rc
		fi
	fi
fi
}

function registerKAK2Chrome {
#echo "installing chrome extension and Native messaging.."
	echo "installing Native messaging.."
	chmod +x $COMPONENT_DIR/mci-proxy-host
	$COMPONENT_DIR/mci-proxy-host d
}


function checkInstalledCrPlusCSeFiles {
#check installed cryptoplus middleware files in home csas dir
    echo -n "CryptoPlus CSe middleware files exist ... "
    for f in ${CSEFILES[*]} ; do
		checkFile $CSASHOME/$f 
    done  
    echo "OK"
}

function checkInstalledKAKfiles {
#check installed kak files in home csas dir
    echo -n "KAK files exist ... "
    for f in ${KAKFILES[*]} ; do
		checkFile $CSASHOME/$f 
    done  
    echo "OK"
}

function checkRegisteredKAK4Mozilla {
#check registering KAK plugin in Mozilla browser
    echo -n "KAK registation in Mozilla plugin dir ... "
    if [ -h $LIBNPCOMP ] ; then
        echo "OK"
    else 
	echo "FAIL"
	exit 18
    fi
}

function checkRegisteredKAK4Opera {
#check registering KAK plugin in Opera browser
    echo -n "KAK registation in Opera ... "
    if [ -f $OPERA_PLUGINPATH ] && [ -n "$(grep -F "$OPERA_PLUGINS_KEY" $OPERA_PLUGINPATH 2> /dev/null)" ] ; then
        echo "OK"
    else 
	echo "FAIL"
	exit 18
    fi
}

function checkRegisteredKAK4Chrome {
#checking Chrome extension
	if [ ! -f $CSASHOME/mci-proxy-host ] || [ ! -f $CSASHOME/mci-proxy-host.sig ]
	then
		echo "WARNING: Some of the files of Chrome extension or Native messaging is missing."
	else
		echo "Chrome extension and Native messaging seem to be OK."
	fi
}

function displayResultKAK {
echo "-------------------------------------------"
echo "KAK installed successfully. Check your browser's address 'about:plugins' if"
echo "you can see 'Klientska aktivni komponenta CS' installed there."
}

###############################################
#Main
###############################################
checkCSASHOME && \
installFiles
checkMozillaPluginDir && \
checkChromeRunning && \
checkOperaRunning && \
createKAKSymlink && \
registerKAK2Opera && \
registerKAK2Chrome && \
checkInstalledCrPlusCSeFiles && \
checkInstalledKAKfiles && \
checkRegisteredKAK4Mozilla && \
checkRegisteredKAK4Opera && \
checkRegisteredKAK4Chrome && \
displayResultKAK
